#ifndef LLF_ECPKI_Common_H
#define LLF_ECPKI_Common_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"
#include "tomcrypt.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Tues Mar 03 09:00:00 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of common usage
*  low level functions for ECC 
*
* \version LLF_ECPKI_Common.h#1:csrc:1
* \author Yermalayeu Ihar
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_ECPKI_DomainIdToModulusSize
*
* Inputs:
* @param domainId [in] - The enumerator variable defines the current EC domain.
*
* Outputs: @returns \b
*  DxUint_t - Modulus size for current ECC domain ID.
*
* \brief \b 
* Description:
*  This function return modulus size for current ECC domain ID.
*
* \b 
* Algorithm:
*  -# Return modulus size for current ECC domain ID.
***************************************************************/
DxUint_t LLF_ECPKI_DomainIdToModulusSize(CE2_ECPKI_DomainID_t domainId);

/**
****************************************************************
* Function Name: 
*  LLF_ECPKI_DomainIdToOrderSizeInBytes
*
* Inputs:
* @param domainId [in] - The enumerator variable defines the current EC domain.
*
* Outputs: @returns \b
*  DxUint_t - Order size for current ECC domain ID in bytes.
*
* \brief \b 
* Description:
*  This function return order size for current ECC domain ID in bytes.
*
* \b 
* Algorithm:
*  -# Return order size for current ECC domain ID.
***************************************************************/
DxUint_t LLF_ECPKI_DomainIdToOrderSizeInBytes(CE2_ECPKI_DomainID_t domainId);

/**
****************************************************************
* Function Name: 
*  LLF_ECPKI_DomainIdToOrderSizeInBits
*
* Inputs:
* @param domainId [in] - The enumerator variable defines the current EC domain.
*
* Outputs: @returns \b
*  DxUint_t - Order size for current ECC domain ID in bits.
*
* \brief \b 
* Description:
*  This function return order size for current ECC domain ID in bits.
*
* \b 
* Algorithm:
*  -# Return order size for current ECC domain ID.
***************************************************************/
DxUint_t LLF_ECPKI_DomainIdToOrderSizeInBits(CE2_ECPKI_DomainID_t domainId);

/**
****************************************************************
* Function Name: 
*  LLF_ECPKI_PRNG_Init
*
* Inputs:
* @param prng [in] - The pointer to PRNG structure.
* @param wprng [in] - The pointer to index of the PRNG.
*
* Outputs: @returns \b
*  CE2Error_t - On success returns CE2_OK; else return error code.
*
* \brief \b 
* Description:
*  This function initialize Pseudo-Random Number Generator  
* ("fortuna" generator is used). 
*  
* \b 
* Algorithm:
*  -# Create and initialize Pseudo-Random Number Generators
***************************************************************/
CE2Error_t LLF_ECPKI_PRNG_Init(prng_state *prng, int *wprng);

#ifdef __cplusplus
}
#endif

#endif /* LLF_ECPKI_Common_H */
